/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.train.TrainCargoManager;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.CarriageEntityHandler;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.mutable.MutableDouble;

public class Carriage {
    public static final AtomicInteger netIdGenerator = new AtomicInteger();
    public Train train;
    public int id;
    public boolean blocked;
    public boolean stalled;
    public Couple<Boolean> presentConductors;
    public int bogeySpacing;
    public Couple<CarriageBogey> bogeys;
    public TrainCargoManager storage;
    CompoundTag serialisedEntity;
    Map<Integer, CompoundTag> serialisedPassengers;
    private Map<ResourceKey<Level>, DimensionalCarriageEntity> entities;
    static final int FIRST = 0;
    static final int MIDDLE = 1;
    static final int LAST = 2;
    static final int BOTH = 3;
    private Set<ResourceKey<Level>> currentlyTraversedDimensions = new HashSet<ResourceKey<Level>>();
    private TravellingPoint portalScout = new TravellingPoint();

    public Carriage(CarriageBogey bogey1, @Nullable CarriageBogey bogey2, int bogeySpacing) {
        this.bogeySpacing = bogeySpacing;
        this.bogeys = Couple.create(bogey1, bogey2);
        this.id = netIdGenerator.incrementAndGet();
        this.serialisedEntity = new CompoundTag();
        this.presentConductors = Couple.create(false, false);
        this.serialisedPassengers = new HashMap<Integer, CompoundTag>();
        this.entities = new HashMap<ResourceKey<Level>, DimensionalCarriageEntity>();
        this.storage = new TrainCargoManager();
        bogey1.setLeading();
        bogey1.carriage = this;
        if (bogey2 != null) {
            bogey2.carriage = this;
        }
    }

    public void setTrain(Train train) {
        this.train = train;
    }

    public boolean presentInMultipleDimensions() {
        return this.entities.size() > 1;
    }

    public void setContraption(Level level, CarriageContraption contraption) {
        this.storage = null;
        CarriageContraptionEntity entity = CarriageContraptionEntity.create(level, contraption);
        entity.setCarriage(this);
        contraption.startMoving(level);
        contraption.onEntityInitialize(level, entity);
        this.updateContraptionAnchors();
        DimensionalCarriageEntity dimensional = this.getDimensional(level);
        dimensional.alignEntity(entity);
        dimensional.removeAndSaveEntity(entity, false);
    }

    public DimensionalCarriageEntity getDimensional(Level level) {
        return this.getDimensional((ResourceKey<Level>)level.m_46472_());
    }

    public DimensionalCarriageEntity getDimensional(ResourceKey<Level> dimension) {
        return this.entities.computeIfAbsent(dimension, $ -> new DimensionalCarriageEntity());
    }

    @Nullable
    public DimensionalCarriageEntity getDimensionalIfPresent(ResourceKey<Level> dimension) {
        return this.entities.get(dimension);
    }

    public double travel(Level level, TrackGraph graph, double distance, TravellingPoint toFollowForward, TravellingPoint toFollowBackward, int type) {
        Function<TravellingPoint, TravellingPoint.ITrackSelector> forwardControl;
        Function<TravellingPoint, TravellingPoint.ITrackSelector> function = toFollowForward == null ? this.train.navigation::control : (forwardControl = mp -> mp.follow(toFollowForward));
        Function<TravellingPoint, TravellingPoint.ITrackSelector> backwardControl = toFollowBackward == null ? this.train.navigation::control : mp -> mp.follow(toFollowBackward);
        boolean onTwoBogeys = this.isOnTwoBogeys();
        double stress = this.train.derailed ? 0.0 : (onTwoBogeys ? (double)this.bogeySpacing - this.getAnchorDiff() : 0.0);
        this.blocked = false;
        MutableDouble distanceMoved = new MutableDouble(distance);
        boolean iterateFromBack = distance < 0.0;
        for (boolean firstBogey : Iterate.trueAndFalse) {
            if (!firstBogey && !onTwoBogeys) continue;
            boolean actuallyFirstBogey = !onTwoBogeys || firstBogey ^ iterateFromBack;
            CarriageBogey bogey = this.bogeys.get(actuallyFirstBogey);
            double bogeyCorrection = stress * (actuallyFirstBogey ? 0.5 : -0.5);
            double bogeyStress = bogey.getStress();
            for (boolean firstWheel : Iterate.trueAndFalse) {
                TravellingPoint.ITrackSelector trackSelector;
                TravellingPoint prevPoint;
                boolean actuallyFirstWheel = firstWheel ^ iterateFromBack;
                TravellingPoint point = bogey.points.get(actuallyFirstWheel);
                TravellingPoint travellingPoint = !actuallyFirstWheel ? (TravellingPoint)bogey.points.getFirst() : (prevPoint = !actuallyFirstBogey && onTwoBogeys ? (TravellingPoint)((CarriageBogey)this.bogeys.getFirst()).points.getSecond() : null);
                TravellingPoint nextPoint = actuallyFirstWheel ? (TravellingPoint)bogey.points.getSecond() : (actuallyFirstBogey && onTwoBogeys ? (TravellingPoint)((CarriageBogey)this.bogeys.getSecond()).points.getFirst() : null);
                double correction = bogeyStress * (actuallyFirstWheel ? 0.5 : -0.5);
                double toMove = distanceMoved.getValue();
                TravellingPoint.ITrackSelector frontTrackSelector = prevPoint == null ? forwardControl.apply(point) : point.follow(prevPoint);
                TravellingPoint.ITrackSelector backTrackSelector = nextPoint == null ? backwardControl.apply(point) : point.follow(nextPoint);
                boolean atFront = (type == 0 || type == 3) && actuallyFirstWheel && actuallyFirstBogey;
                boolean atBack = !(type != 2 && type != 3 || actuallyFirstWheel || actuallyFirstBogey && onTwoBogeys);
                TravellingPoint.IEdgePointListener frontListener = this.train.frontSignalListener();
                TravellingPoint.IEdgePointListener backListener = this.train.backSignalListener();
                TravellingPoint.IEdgePointListener passiveListener = point.ignoreEdgePoints();
                TravellingPoint.ITrackSelector iTrackSelector = trackSelector = (toMove += correction + bogeyCorrection) > 0.0 ? frontTrackSelector : backTrackSelector;
                TravellingPoint.IEdgePointListener signalListener = toMove > 0.0 ? (atFront ? frontListener : (atBack ? backListener : passiveListener)) : (atFront ? backListener : (atBack ? frontListener : passiveListener));
                double moved = point.travel(graph, toMove, trackSelector, signalListener, point.ignoreTurns(), c -> {
                    for (DimensionalCarriageEntity dce : this.entities.values()) {
                        if (!c.either(tnl -> tnl.equalsIgnoreDim((Object)dce.pivot))) continue;
                        return false;
                    }
                    if (this.entities.size() > 1) {
                        this.train.status.doublePortal();
                        return true;
                    }
                    return false;
                });
                this.blocked |= point.blocked;
                distanceMoved.setValue(moved);
            }
        }
        this.updateContraptionAnchors();
        this.manageEntities(level);
        return distanceMoved.getValue();
    }

    public double getAnchorDiff() {
        double diff = 0.0;
        int entries = 0;
        TravellingPoint leadingPoint = this.getLeadingPoint();
        TravellingPoint trailingPoint = this.getTrailingPoint();
        if (leadingPoint.node1 != null && trailingPoint.node1 != null && !leadingPoint.node1.getLocation().dimension.equals(trailingPoint.node1.getLocation().dimension)) {
            return this.bogeySpacing;
        }
        for (DimensionalCarriageEntity dce : this.entities.values()) {
            if (dce.leadingAnchor() == null || dce.trailingAnchor() == null) continue;
            ++entries;
            diff += dce.leadingAnchor().m_82554_(dce.trailingAnchor());
        }
        if (entries == 0) {
            return this.bogeySpacing;
        }
        return diff / (double)entries;
    }

    public void updateConductors() {
        if (this.anyAvailableEntity() == null || this.entities.size() > 1 || this.serialisedPassengers.size() > 0) {
            return;
        }
        this.presentConductors.replace($ -> false);
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity == null || !entity.m_6084_()) continue;
            this.presentConductors.replaceWithParams((current, checked) -> current != false || checked != false, entity.checkConductors());
        }
    }

    public void manageEntities(Level level) {
        this.currentlyTraversedDimensions.clear();
        this.bogeys.forEach(cb -> {
            if (cb == null) {
                return;
            }
            cb.points.forEach(tp -> {
                if (tp.node1 == null) {
                    return;
                }
                this.currentlyTraversedDimensions.add(tp.node1.getLocation().dimension);
            });
        });
        Iterator<Map.Entry<ResourceKey<Level>, DimensionalCarriageEntity>> iterator = this.entities.entrySet().iterator();
        while (iterator.hasNext()) {
            CarriageContraptionEntity entity;
            DimensionalCarriageEntity dimensionalCarriageEntity;
            block6: {
                boolean discard;
                block4: {
                    ServerLevel currentLevel;
                    block5: {
                        Map.Entry<ResourceKey<Level>, DimensionalCarriageEntity> entry = iterator.next();
                        discard = !this.currentlyTraversedDimensions.isEmpty() && !this.currentlyTraversedDimensions.contains(entry.getKey());
                        currentLevel = level.m_142572_().m_129880_(entry.getKey());
                        if (currentLevel == null) continue;
                        dimensionalCarriageEntity = entry.getValue();
                        entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
                        if (entity != null) break block4;
                        if (!discard) break block5;
                        iterator.remove();
                        break block6;
                    }
                    if (dimensionalCarriageEntity.positionAnchor == null || !CarriageEntityHandler.isActiveChunk((Level)currentLevel, new BlockPos(dimensionalCarriageEntity.positionAnchor))) break block6;
                    dimensionalCarriageEntity.createEntity((Level)currentLevel, this.anyAvailableEntity() == null);
                    break block6;
                }
                if (discard) {
                    discard = dimensionalCarriageEntity.discardTicks > 3;
                    ++dimensionalCarriageEntity.discardTicks;
                } else {
                    dimensionalCarriageEntity.discardTicks = 0;
                }
                CarriageEntityHandler.validateCarriageEntity(entity);
                if (!entity.m_6084_() || entity.leftTickingChunks || discard) {
                    dimensionalCarriageEntity.removeAndSaveEntity(entity, discard);
                    if (!discard) continue;
                    iterator.remove();
                    continue;
                }
            }
            if ((entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get())) == null || dimensionalCarriageEntity.positionAnchor == null) continue;
            dimensionalCarriageEntity.alignEntity(entity);
            entity.syncCarriage();
        }
    }

    public void updateContraptionAnchors() {
        CarriageBogey leadingBogey = this.leadingBogey();
        if (leadingBogey.points.either(t -> t.edge == null)) {
            return;
        }
        CarriageBogey trailingBogey = this.trailingBogey();
        if (trailingBogey.points.either(t -> t.edge == null)) {
            return;
        }
        ResourceKey<Level> leadingBogeyDim = leadingBogey.getDimension();
        ResourceKey<Level> trailingBogeyDim = trailingBogey.getDimension();
        double leadingWheelSpacing = leadingBogey.type.getWheelPointSpacing();
        double trailingWheelSpacing = trailingBogey.type.getWheelPointSpacing();
        for (boolean leading : Iterate.trueAndFalse) {
            TravellingPoint point = leading ? this.getLeadingPoint() : this.getTrailingPoint();
            TravellingPoint otherPoint = !leading ? this.getLeadingPoint() : this.getTrailingPoint();
            ResourceKey<Level> dimension = point.node1.getLocation().dimension;
            ResourceKey<Level> otherDimension = otherPoint.node1.getLocation().dimension;
            if (dimension.equals(otherDimension) && leading) {
                this.getDimensional(dimension).discardPivot();
                continue;
            }
            DimensionalCarriageEntity dce = this.getDimensional(dimension);
            Vec3 vec3 = dimension.equals(leadingBogeyDim) ? leadingBogey.getAnchorPosition() : (dce.positionAnchor = this.pivoted(dce, dimension, point, leading ? leadingWheelSpacing / 2.0 : (double)this.bogeySpacing + trailingWheelSpacing / 2.0));
            if (this.isOnTwoBogeys()) {
                dce.rotationAnchors.setFirst(dimension.equals(leadingBogeyDim) ? leadingBogey.getAnchorPosition() : this.pivoted(dce, dimension, point, leading ? leadingWheelSpacing / 2.0 : (double)this.bogeySpacing + trailingWheelSpacing / 2.0));
                dce.rotationAnchors.setSecond(dimension.equals(trailingBogeyDim) ? trailingBogey.getAnchorPosition() : this.pivoted(dce, dimension, point, leading ? leadingWheelSpacing / 2.0 + (double)this.bogeySpacing : trailingWheelSpacing / 2.0));
            } else if (dimension.equals(otherDimension)) {
                dce.rotationAnchors = leadingBogey.points.map(TravellingPoint::getPosition);
            } else {
                dce.rotationAnchors.setFirst(leadingBogey.points.getFirst() == point ? point.getPosition() : this.pivoted(dce, dimension, point, leadingWheelSpacing));
                dce.rotationAnchors.setSecond(leadingBogey.points.getSecond() == point ? point.getPosition() : this.pivoted(dce, dimension, point, leadingWheelSpacing));
            }
            int prevmin = dce.minAllowedLocalCoord();
            int prevmax = dce.maxAllowedLocalCoord();
            dce.updateCutoff(leading);
            if (prevmin == dce.minAllowedLocalCoord() && prevmax == dce.maxAllowedLocalCoord()) continue;
            dce.updateRenderedCutoff();
            dce.updatePassengerLoadout();
        }
    }

    private Vec3 pivoted(DimensionalCarriageEntity dce, ResourceKey<Level> dimension, TravellingPoint start, double offset) {
        if (this.train.graph == null) {
            return dce.pivot == null ? null : dce.pivot.getLocation();
        }
        TrackNodeLocation pivot = dce.findPivot(dimension, start == this.getLeadingPoint());
        if (pivot == null) {
            return null;
        }
        Vec3 startVec = start.getPosition();
        Vec3 portalVec = pivot.getLocation().m_82520_(0.0, 1.0, 0.0);
        return VecHelper.lerp((float)(offset / startVec.m_82554_(portalVec)), startVec, portalVec);
    }

    public void alignEntity(Level level) {
        CarriageContraptionEntity entity;
        DimensionalCarriageEntity dimensionalCarriageEntity = this.entities.get(level.m_46472_());
        if (dimensionalCarriageEntity != null && (entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get())) != null) {
            dimensionalCarriageEntity.alignEntity(entity);
        }
    }

    public TravellingPoint getLeadingPoint() {
        return this.leadingBogey().leading();
    }

    public TravellingPoint getTrailingPoint() {
        return this.trailingBogey().trailing();
    }

    public CarriageBogey leadingBogey() {
        return (CarriageBogey)this.bogeys.getFirst();
    }

    public CarriageBogey trailingBogey() {
        return this.isOnTwoBogeys() ? (CarriageBogey)this.bogeys.getSecond() : this.leadingBogey();
    }

    public boolean isOnTwoBogeys() {
        return this.bogeys.getSecond() != null;
    }

    public CarriageContraptionEntity anyAvailableEntity() {
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public void forEachPresentEntity(Consumer<CarriageContraptionEntity> callback) {
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity == null) continue;
            callback.accept(entity);
        }
    }

    public CompoundTag write(DimensionPalette dimensions) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("FirstBogey", (Tag)((CarriageBogey)this.bogeys.getFirst()).write(dimensions));
        if (this.isOnTwoBogeys()) {
            tag.m_128365_("SecondBogey", (Tag)((CarriageBogey)this.bogeys.getSecond()).write(dimensions));
        }
        tag.m_128405_("Spacing", this.bogeySpacing);
        tag.m_128379_("FrontConductor", ((Boolean)this.presentConductors.getFirst()).booleanValue());
        tag.m_128379_("BackConductor", ((Boolean)this.presentConductors.getSecond()).booleanValue());
        tag.m_128379_("Stalled", this.stalled);
        HashMap<Integer, CompoundTag> passengerMap = new HashMap<Integer, CompoundTag>();
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity == null) continue;
            this.serialize(entity);
            Contraption contraption = entity.getContraption();
            if (contraption == null) continue;
            Map<UUID, Integer> mapping = contraption.getSeatMapping();
            for (Entity passenger : entity.m_20197_()) {
                if (!mapping.containsKey(passenger.m_142081_())) continue;
                passengerMap.put(mapping.get(passenger.m_142081_()), passenger.serializeNBT());
            }
        }
        tag.m_128365_("Entity", (Tag)this.serialisedEntity.m_6426_());
        CompoundTag passengerTag = new CompoundTag();
        passengerMap.putAll(this.serialisedPassengers);
        passengerMap.forEach((seat, nbt) -> passengerTag.m_128365_("Seat" + seat, (Tag)nbt.m_6426_()));
        tag.m_128365_("Passengers", (Tag)passengerTag);
        tag.m_128365_("EntityPositioning", (Tag)NBTHelper.writeCompoundList(this.entities.entrySet(), e -> {
            CompoundTag c = ((DimensionalCarriageEntity)e.getValue()).write();
            c.m_128405_("Dim", dimensions.encode((ResourceKey<Level>)((ResourceKey)e.getKey())));
            return c;
        }));
        return tag;
    }

    private void serialize(Entity entity) {
        this.serialisedEntity = entity.serializeNBT();
        this.serialisedEntity.m_128473_("Passengers");
        this.serialisedEntity.m_128469_("Contraption").m_128473_("Passengers");
    }

    public static Carriage read(CompoundTag tag, TrackGraph graph, DimensionPalette dimensions) {
        CarriageBogey bogey1 = CarriageBogey.read(tag.m_128469_("FirstBogey"), graph, dimensions);
        CarriageBogey bogey2 = tag.m_128441_("SecondBogey") ? CarriageBogey.read(tag.m_128469_("SecondBogey"), graph, dimensions) : null;
        Carriage carriage = new Carriage(bogey1, bogey2, tag.m_128451_("Spacing"));
        carriage.stalled = tag.m_128471_("Stalled");
        carriage.presentConductors = Couple.create(tag.m_128471_("FrontConductor"), tag.m_128471_("BackConductor"));
        carriage.serialisedEntity = tag.m_128469_("Entity").m_6426_();
        NBTHelper.iterateCompoundList(tag.m_128437_("EntityPositioning", 10), c -> carriage.getDimensional(dimensions.decode(c.m_128451_("Dim"))).read((CompoundTag)c));
        CompoundTag passengersTag = tag.m_128469_("Passengers");
        passengersTag.m_128431_().forEach(key -> carriage.serialisedPassengers.put(Integer.valueOf(key.substring(4)), passengersTag.m_128469_(key)));
        return carriage;
    }

    public class DimensionalCarriageEntity {
        public Vec3 positionAnchor;
        public Couple<Vec3> rotationAnchors;
        public WeakReference<CarriageContraptionEntity> entity = new WeakReference<Object>(null);
        public TrackNodeLocation pivot;
        int discardTicks;
        public float cutoff;
        public boolean pointsInitialised = false;

        public DimensionalCarriageEntity() {
            this.rotationAnchors = Couple.create(null, null);
        }

        public void discardPivot() {
            int prevmin = this.minAllowedLocalCoord();
            int prevmax = this.maxAllowedLocalCoord();
            this.cutoff = 0.0f;
            this.pivot = null;
            if (!Carriage.this.serialisedPassengers.isEmpty() && this.entity.get() != null || prevmin != this.minAllowedLocalCoord() || prevmax != this.maxAllowedLocalCoord()) {
                this.updatePassengerLoadout();
                this.updateRenderedCutoff();
            }
        }

        public void updateCutoff(boolean leadingIsCurrent) {
            Vec3 leadingAnchor = (Vec3)this.rotationAnchors.getFirst();
            Vec3 trailingAnchor = (Vec3)this.rotationAnchors.getSecond();
            if (leadingAnchor == null || trailingAnchor == null) {
                return;
            }
            if (this.pivot == null) {
                this.cutoff = 0.0f;
                return;
            }
            Vec3 pivotLoc = this.pivot.getLocation().m_82520_(0.0, 1.0, 0.0);
            double leadingSpacing = Carriage.this.leadingBogey().type.getWheelPointSpacing() / 2.0;
            double trailingSpacing = Carriage.this.trailingBogey().type.getWheelPointSpacing() / 2.0;
            double anchorSpacing = leadingSpacing + (double)Carriage.this.bogeySpacing + trailingSpacing;
            if (Carriage.this.isOnTwoBogeys()) {
                Vec3 diff = trailingAnchor.m_82546_(leadingAnchor).m_82541_();
                trailingAnchor = trailingAnchor.m_82549_(diff.m_82490_(trailingSpacing));
                leadingAnchor = leadingAnchor.m_82549_(diff.m_82490_(-leadingSpacing));
            }
            double leadingDiff = leadingAnchor.m_82554_(pivotLoc);
            double trailingDiff = trailingAnchor.m_82554_(pivotLoc);
            this.cutoff = leadingIsCurrent && leadingDiff > trailingDiff && leadingDiff > 1.0 ? 0.0f : (leadingIsCurrent && leadingDiff < trailingDiff && trailingDiff > 1.0 ? 1.0f : (!leadingIsCurrent && leadingDiff > trailingDiff && leadingDiff > 1.0 ? -1.0f : (!leadingIsCurrent && leadingDiff < trailingDiff && trailingDiff > 1.0 ? 0.0f : (float)Mth.m_14008_((double)(1.0 - (leadingIsCurrent ? (leadingDiff /= anchorSpacing) : (trailingDiff /= anchorSpacing))), (double)0.0, (double)1.0) * (float)(leadingIsCurrent ? 1 : -1))));
        }

        public TrackNodeLocation findPivot(ResourceKey<Level> dimension, boolean leading) {
            if (this.pivot != null) {
                return this.pivot;
            }
            TravellingPoint start = leading ? Carriage.this.getLeadingPoint() : Carriage.this.getTrailingPoint();
            TravellingPoint end = !leading ? Carriage.this.getLeadingPoint() : Carriage.this.getTrailingPoint();
            Carriage.this.portalScout.node1 = start.node1;
            Carriage.this.portalScout.node2 = start.node2;
            Carriage.this.portalScout.edge = start.edge;
            Carriage.this.portalScout.position = start.position;
            TravellingPoint.ITrackSelector trackSelector = Carriage.this.portalScout.follow(end);
            int distance = Carriage.this.bogeySpacing + 10;
            int direction = leading ? -1 : 1;
            Carriage.this.portalScout.travel(Carriage.this.train.graph, direction * distance, trackSelector, Carriage.this.portalScout.ignoreEdgePoints(), Carriage.this.portalScout.ignoreTurns(), nodes -> {
                for (boolean b : Iterate.trueAndFalse) {
                    if (!((TrackNodeLocation)((Object)((Object)nodes.get((boolean)b)))).dimension.equals((Object)dimension)) continue;
                    this.pivot = (TrackNodeLocation)((Object)((Object)nodes.get(b)));
                }
                return true;
            });
            return this.pivot;
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("Cutoff", this.cutoff);
            tag.m_128405_("DiscardTicks", this.discardTicks);
            Carriage.this.storage.write(tag, false);
            if (this.pivot != null) {
                tag.m_128365_("Pivot", (Tag)this.pivot.write(null));
            }
            if (this.positionAnchor != null) {
                tag.m_128365_("PositionAnchor", (Tag)VecHelper.writeNBT(this.positionAnchor));
            }
            if (this.rotationAnchors.both(Objects::nonNull)) {
                tag.m_128365_("RotationAnchors", (Tag)this.rotationAnchors.serializeEach(VecHelper::writeNBTCompound));
            }
            return tag;
        }

        public void read(CompoundTag tag) {
            this.cutoff = tag.m_128457_("Cutoff");
            this.discardTicks = tag.m_128451_("DiscardTicks");
            Carriage.this.storage.read(tag, null, false);
            if (tag.m_128441_("Pivot")) {
                this.pivot = TrackNodeLocation.read(tag.m_128469_("Pivot"), null);
            }
            if (this.positionAnchor != null) {
                return;
            }
            if (tag.m_128441_("PositionAnchor")) {
                this.positionAnchor = VecHelper.readNBT(tag.m_128437_("PositionAnchor", 6));
            }
            if (tag.m_128441_("RotationAnchors")) {
                this.rotationAnchors = Couple.deserializeEach(tag.m_128437_("RotationAnchors", 10), VecHelper::readNBTCompound);
            }
        }

        public Vec3 leadingAnchor() {
            return Carriage.this.isOnTwoBogeys() ? (Vec3)this.rotationAnchors.getFirst() : this.positionAnchor;
        }

        public Vec3 trailingAnchor() {
            return Carriage.this.isOnTwoBogeys() ? (Vec3)this.rotationAnchors.getSecond() : this.positionAnchor;
        }

        public int minAllowedLocalCoord() {
            if (this.cutoff <= 0.0f) {
                return Integer.MIN_VALUE;
            }
            if (this.cutoff >= 1.0f) {
                return Integer.MAX_VALUE;
            }
            return Mth.m_14143_((float)((float)(-Carriage.this.bogeySpacing + -1) + (float)(2 + Carriage.this.bogeySpacing) * this.cutoff));
        }

        public int maxAllowedLocalCoord() {
            if (this.cutoff >= 0.0f) {
                return Integer.MAX_VALUE;
            }
            if (this.cutoff <= -1.0f) {
                return Integer.MIN_VALUE;
            }
            return Mth.m_14167_((float)((float)(-Carriage.this.bogeySpacing + -1) + (float)(2 + Carriage.this.bogeySpacing) * (this.cutoff + 1.0f)));
        }

        public void updatePassengerLoadout() {
            Entity entity = (Entity)this.entity.get();
            if (!(entity instanceof CarriageContraptionEntity)) {
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            Level level = entity.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel sLevel = (ServerLevel)level;
            HashSet<Integer> loadedPassengers = new HashSet<Integer>();
            int min = this.minAllowedLocalCoord();
            int max = this.maxAllowedLocalCoord();
            for (Map.Entry<Integer, CompoundTag> entry : Carriage.this.serialisedPassengers.entrySet()) {
                BlockPos localPos;
                Integer seatId = entry.getKey();
                List<BlockPos> seats = cce.getContraption().getSeats();
                if (seatId >= seats.size() || !cce.isLocalCoordWithin(localPos = seats.get(seatId), min, max)) continue;
                CompoundTag tag = entry.getValue();
                Entity passenger = null;
                if (tag.m_128441_("PlayerPassenger")) {
                    passenger = sLevel.m_142572_().m_6846_().m_11259_(tag.m_128342_("PlayerPassenger"));
                } else {
                    passenger = EntityType.m_20645_((CompoundTag)tag, (Level)entity.f_19853_, e -> {
                        e.m_20219_(this.positionAnchor);
                        return e;
                    });
                    if (passenger != null) {
                        sLevel.m_8860_(passenger);
                    }
                }
                if (passenger != null) {
                    ResourceKey passengerDimension = passenger.f_19853_.m_46472_();
                    if (!passengerDimension.equals((Object)sLevel.m_46472_()) && passenger instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)passenger;
                        continue;
                    }
                    cce.addSittingPassenger(passenger, seatId);
                }
                loadedPassengers.add(seatId);
            }
            loadedPassengers.forEach(Carriage.this.serialisedPassengers::remove);
            Map<UUID, Integer> mapping = cce.getContraption().getSeatMapping();
            for (Entity passenger : entity.m_20197_()) {
                BlockPos localPos = cce.getContraption().getSeatOf(passenger.m_142081_());
                if (cce.isLocalCoordWithin(localPos, min, max) || !mapping.containsKey(passenger.m_142081_())) continue;
                Integer seat = mapping.get(passenger.m_142081_());
                if (passenger instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)passenger;
                    this.dismountPlayer(sLevel, sp, seat, true);
                    continue;
                }
                Carriage.this.serialisedPassengers.put(seat, passenger.serializeNBT());
                passenger.m_146870_();
            }
        }

        private void dismountPlayer(ServerLevel sLevel, ServerPlayer sp, Integer seat, boolean portal) {
            if (!portal) {
                sp.m_8127_();
                return;
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("PlayerPassenger", sp.m_142081_());
            Carriage.this.serialisedPassengers.put(seat, tag);
            sp.m_8127_();
            sp.getPersistentData().m_128473_("ContraptionDismountLocation");
            for (Map.Entry<ResourceKey<Level>, DimensionalCarriageEntity> other : Carriage.this.entities.entrySet()) {
                Vec3 loc;
                DimensionalCarriageEntity otherDce = other.getValue();
                if (otherDce == this || sp.f_19853_.m_46472_().equals(other.getKey())) continue;
                Vec3 vec3 = loc = otherDce.pivot == null ? otherDce.positionAnchor : otherDce.pivot.getLocation();
                if (loc == null) continue;
                ServerLevel level = sLevel.m_142572_().m_129880_(other.getKey());
                sp.m_8999_(level, loc.f_82479_, loc.f_82480_, loc.f_82481_, sp.m_146908_(), sp.m_146909_());
                sp.m_20091_();
                AllAdvancements.TRAIN_PORTAL.awardTo((Player)sp);
            }
        }

        public void updateRenderedCutoff() {
            Entity entity = (Entity)this.entity.get();
            if (!(entity instanceof CarriageContraptionEntity)) {
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            Contraption contraption = cce.getContraption();
            if (!(contraption instanceof CarriageContraption)) {
                return;
            }
            CarriageContraption cc = (CarriageContraption)contraption;
            cc.portalCutoffMin = this.minAllowedLocalCoord();
            cc.portalCutoffMax = this.maxAllowedLocalCoord();
            if (!entity.f_19853_.m_5776_()) {
                return;
            }
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.invalidate(cce));
        }

        @OnlyIn(value=Dist.CLIENT)
        private void invalidate(CarriageContraptionEntity entity) {
            entity.getContraption().deferInvalidate = true;
            entity.updateRenderedPortalCutoff();
        }

        private void createEntity(Level level, boolean loadPassengers) {
            Entity entity = EntityType.m_20642_((CompoundTag)Carriage.this.serialisedEntity, (Level)level).orElse(null);
            if (!(entity instanceof CarriageContraptionEntity)) {
                Carriage.this.train.invalid = true;
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            entity.m_20219_(this.positionAnchor);
            this.entity = new WeakReference<CarriageContraptionEntity>(cce);
            cce.setCarriage(Carriage.this);
            cce.syncCarriage();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                sl.m_7967_(entity);
            }
            this.updatePassengerLoadout();
        }

        private void removeAndSaveEntity(CarriageContraptionEntity entity, boolean portal) {
            Contraption contraption = entity.getContraption();
            if (contraption != null) {
                Map<UUID, Integer> mapping = contraption.getSeatMapping();
                for (Entity passenger : entity.m_20197_()) {
                    if (!mapping.containsKey(passenger.m_142081_())) continue;
                    Integer seat = mapping.get(passenger.m_142081_());
                    if (passenger instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)passenger;
                        this.dismountPlayer(sp.m_183503_(), sp, seat, portal);
                        continue;
                    }
                    Carriage.this.serialisedPassengers.put(seat, passenger.serializeNBT());
                }
            }
            for (Entity passenger : entity.m_20197_()) {
                if (passenger instanceof Player) continue;
                passenger.m_146870_();
            }
            Carriage.this.serialize(entity);
            entity.m_146870_();
            this.entity.clear();
        }

        public void alignEntity(CarriageContraptionEntity entity) {
            if (this.rotationAnchors.either(Objects::isNull)) {
                return;
            }
            Vec3 positionVec = (Vec3)this.rotationAnchors.getFirst();
            Vec3 coupledVec = (Vec3)this.rotationAnchors.getSecond();
            double diffX = positionVec.f_82479_ - coupledVec.f_82479_;
            double diffY = positionVec.f_82480_ - coupledVec.f_82480_;
            double diffZ = positionVec.f_82481_ - coupledVec.f_82481_;
            entity.prevYaw = entity.yaw;
            entity.prevPitch = entity.pitch;
            if (!entity.f_19853_.m_5776_()) {
                Vec3 lookahead = this.positionAnchor.m_82549_(this.positionAnchor.m_82546_(entity.m_20182_()).m_82541_().m_82490_(16.0));
                for (Entity e : entity.m_20197_()) {
                    if (!(e instanceof Player) || e.m_20280_((Entity)entity) > 1024.0) continue;
                    if (CarriageEntityHandler.isActiveChunk(entity.f_19853_, new BlockPos(lookahead))) break;
                    Carriage.this.train.carriageWaitingForChunks = Carriage.this.id;
                    return;
                }
                if (entity.m_20197_().stream().anyMatch(p -> p instanceof Player)) {
                    // empty if block
                }
                if (Carriage.this.train.carriageWaitingForChunks == Carriage.this.id) {
                    Carriage.this.train.carriageWaitingForChunks = -1;
                }
                entity.setServerSidePrevPosition();
            }
            entity.m_146884_(this.positionAnchor);
            entity.yaw = (float)(Mth.m_14136_((double)diffZ, (double)diffX) * 180.0 / Math.PI) + 180.0f;
            entity.pitch = (float)(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)) * 180.0 / Math.PI) * -1.0f;
            if (!entity.firstPositionUpdate) {
                return;
            }
            entity.f_19854_ = entity.m_20185_();
            entity.f_19855_ = entity.m_20186_();
            entity.f_19856_ = entity.m_20189_();
            entity.prevYaw = entity.yaw;
            entity.prevPitch = entity.pitch;
        }
    }
}

